/*=========================================================================================
    File Name: app-notification.js
    Description: app-notification
    ----------------------------------------------------------------------------------------
    Item Name: Vuexy  - Vuejs, HTML & Laravel Admin Dashboard Template
    Author: PIXINVENT
    Author URL: http://www.themeforest.net/user/pixinvent
==========================================================================================*/

$(function() {
  "use strict";

  var $curr_title, $curr_desc, $curr_info, $curr_fav, $curr_chipVal;

  // --------------------------------------------
  // Sidebar menu scrollbar
  // --------------------------------------------
  if($('.noti-application .sidebar-menu-list').length > 0){
      var content = new PerfectScrollbar('.sidebar-menu-list',{
         theme: "dark"
      });
  }

  // --------------------------------------------
  // noti task list scrollbar
  // --------------------------------------------
  if($('.noti-application .noti-task-list').length > 0){
      var sidebar_noti = new PerfectScrollbar('.noti-task-list',{
         theme: "dark"
      });
  }


  // --------------------------------------------
  // Info star click
  // --------------------------------------------
  $(document).on("click", ".noti-application .noti-item-info i", function(e) {
    $(this).parent('.noti-item-info').toggleClass("success");
    e.stopPropagation();
  });


  // --------------------------------------------
  // Favorite star click
  // --------------------------------------------
  $(document).on("click", ".noti-application .noti-item-favorite i", function(e) {
    $(this).parent('.noti-item-favorite').toggleClass("warning");
    e.stopPropagation();
  });

  // --------------------------------------------
  // Main menu toggle should hide app menu
  // --------------------------------------------
  $('.menu-toggle').on('click',function(e){
    $('.app-content .sidebar-left').removeClass('show');
    $('.app-content .app-content-overlay').removeClass('show');
  });

  // --------------------------------------------
  // On sidebar close click
  // --------------------------------------------
  $(".noti-application .sidebar-close-icon").on('click',function(){
    $('.sidebar-left').removeClass('show');
    $('.app-content-overlay').removeClass('show');
  });

  // --------------------------------------------
  // noti sidebar toggle
  // --------------------------------------------
  $('.sidebar-toggle').on('click',function(e){
    e.stopPropagation();
    $('.app-content .sidebar-left').toggleClass('show');
    $('.app-content .app-content-overlay').addClass('show');
  });
  $('.app-content .app-content-overlay').on('click',function(e){
    $('.app-content .sidebar-left').removeClass('show');
    $('.app-content .app-content-overlay').removeClass('show');
  });

  // --------------------------------------------
  // Add class active on click of sidebar filters list
  // --------------------------------------------
  $(".noti-application .list-group-filters a").on('click', function(){
    if($('.noti-application .list-group-filters a').hasClass('active')){
      $('.noti-application .list-group-filters a').removeClass('active');
    }
    $(this).addClass("active");
  });

  // --------------------------------------------
  // For chat sidebar on small screen
  // --------------------------------------------
  if ($(window).width() > 992) {
      if($('.noti-application .app-content-overlay').hasClass('show')){
          $('.noti-application .app-content-overlay').removeClass('show');
      }
  }

  // --------------------------------------------
  // On add new item, clear modal popup fields
  // --------------------------------------------
  $(".add-task button").on('click', function(e){
    $('.modal .new-noti-item-title').val("");
    $('.modal .new-noti-item-desc').val("");
    $('.modal .new-noti-item-bcast').prop();
    $('.modal .new-noti-item-ltime').prop();
    $('.modal .dropdown-menu input').prop("checked", false);
    if($('.modal .noti-item-info').hasClass('success')){$('.modal .noti-item-info').removeClass('success')}
    if($('.modal .noti-item-favorite').hasClass('warning')){$('.modal .noti-item-favorite').removeClass('warning')}
  });


  // --------------------------------------------
  // Add New noti List Item
  // --------------------------------------------


  // To add new noti list item
  $(".add-noti-item").on('click', function(e){
    e.preventDefault();
    var notiInfo = "",
    notiFav = "",
    notiChip = "";

    var notiTitle = $(".new-noti-item-title").val();
    var notiDesc = $(".new-noti-item-desc").val();
    var boardCast = $(".new-noti-item-bcast").val();
    var loopTime = $(".new-noti-item-loop").val();

    if($(".modal.show .noti-item-info").hasClass('success')){
      notiInfo = " success";
    }
    if($(".modal.show .noti-item-favorite").hasClass('warning')){
      notiFav = " warning";
    }

    // Chip calculation loop
    var selected  = $('.modal .dropdown-menu input:checked');

    selected.each(function(){
      notiChip += '<div class="chip mb-0">' +
        '<div class="chip-body">' +
          '<span class="chip-text" data-value="'+$(this).data('value')+'"><span class="bullet bullet-'+$(this).data('color')+' bullet-xs"></span> '+$(this).data('value')+'</span>' +
        '</div>' +
      '</div>';
    });

    // HTML Output
    if(notiTitle != ""){
      $(".noti-task-list-wrapper").append('<li class="noti-item" style="animation-delay: 0s;"  data-toggle="modal" data-target="#editTaskModal">' +
        '<div class="noti-title-wrapper d-flex justify-content-between mb-50">' +
          '<div class="noti-title-area d-flex align-items-center">' +
            '<div class="title-wrapper d-flex">'+
              '<div class="vs-checkbox-con">' +
                  '<input type="checkbox" >' +
                  '<span class="vs-checkbox vs-checkbox-sm">' +
                    '<span class="vs-checkbox--check">' +
                      '<i class="vs-icon feather icon-check"></i>' +
                    '</span>' +
                  '</span>' +
              '</div>' +
              '<h6 class="noti-title mt-50 mx-50">'+ notiTitle +'</h6>' +
            '</div>' +
            '<div class="chip-wrapper">' + notiChip + '</div>' +
          '</div>' +
          '<div class="float-right noti-item-action d-flex">' +
            '<a class="noti-item-info'+ notiInfo +'"><i class="feather icon-info"></i></a>' +
            '<a class="noti-item-favorite'+ notiFav +'"><i class="feather icon-star"></i></a>' +
            '<a class="noti-item-delete"><i class="feather icon-trash"></i></a>' +
          '</div>' +
        '</div>' +
        '<p class="mb-0 noti-desc truncate">'+ notiDesc +'</p>' +
      '</li>');
    }

    $('#form-edit-noti .edit-noti-item-title').val(notiTitle);
    $('#form-edit-noti .edit-noti-item-desc').val(notiDesc);
    $('#form-edit-noti .edit-noti-item-bcast').val(boardCast);
    $('#form-edit-noti .edit-noti-item-ltime').val(loopTime);
    $('#form-edit-noti .dropdown-menu input').prop("checked", false);
    if($('#form-edit-noti .edit-noti-item-info').hasClass('success')){$('#form-edit-noti .edit-noti-item-info').addClass('success')}
    if($('#form-edit-noti .edit-noti-item-favorite').hasClass('warning')){$('#form-edit-noti .edit-noti-item-favorite').addClass('warning')}
  });


  // --------------------------------------------
  // To update noti list item
  // --------------------------------------------
  $(document).on('click',".noti-task-list-wrapper .noti-item", function(e){

    // Saving all values in variable
    $curr_title = $(this).find('.noti-title');  // Set path for Current Title, use this variable when updating title
    $curr_desc = $(this).find('.noti-desc');  // Set path for Current Description, use this variable when updating Description
    $curr_info = $(this).find('.noti-item-info');  // Set path for Current info, use this variable when updating info
    $curr_fav = $(this).find('.noti-item-favorite'); // Set path for Current favorite, use this variable when updating favorite
    $curr_chipVal = $(this).find('.chip-wrapper'); // Set path for Chips, use this variable when updating chip value

    var $title = $(this).find('.noti-title').html();
    var $desc = $(this).find('.noti-desc').html();
    var $info = $(this).find('.noti-item-info');
    var $fav = $(this).find('.noti-item-favorite');
    $('#form-edit-noti .dropdown-menu input').prop("checked",false);


    // Checkbox checked as per chips

    var selected  = $(this).find('.chip');
    selected.each(function(){

      var chipVal = $(this).find('.chip-text').data('value');
      $('#form-edit-noti .dropdown-menu input[data-value="'+chipVal+'"]').prop("checked",true);
    });

    // apply all variable values to fields
    $('#form-edit-noti .edit-noti-item-title').val($title);
    $('#form-edit-noti .edit-noti-item-desc').val($desc);

    if($('#form-edit-noti .noti-item-info').hasClass('success')){$('#form-edit-noti .noti-item-info').removeClass('success')}
    if($('#form-edit-noti .edit-noti-item-favorite').hasClass('warning')){$('#form-edit-noti .edit-noti-item-favorite').removeClass('warning')}

    if( $($info).hasClass('success') ) {
      $('#form-edit-noti .noti-item-info').addClass('success');
    }

    if( $($fav).hasClass('warning') ) {
      $('#form-edit-noti .edit-noti-item-favorite').addClass('warning');
    }
  });


  // --------------------------------------------
  // Updating Data Values to Fields
  // --------------------------------------------
  $('.update-noti-item').on('click', function(){
    var $edit_title = $('#form-edit-noti .edit-noti-item-title').val();
    var $edit_desc = $('#form-edit-noti .edit-noti-item-desc').val();
    var $edit_info = $('#form-edit-noti .noti-item-info i');
    var $edit_fav = $('#form-edit-noti .noti-item-favorite i');

    $($curr_title).text($edit_title);
    $($curr_desc).text($edit_desc);

    if($($curr_info).hasClass('success')){$($curr_info).removeClass('success')}
    if($($curr_fav).hasClass('warning')){$($curr_fav).removeClass('warning')}

    if( $($edit_info).parent('.noti-item-info').hasClass('success')) {
      $curr_info.addClass('success');
    }

    if( $($edit_fav).parent('.noti-item-favorite').hasClass('warning')) {
      $curr_fav.addClass('warning');
    }

    // Chip calculation loop
    var $edit_selected  = $('#form-edit-noti .dropdown-menu input:checked');
    var $edit_notiChip = "";

        $edit_selected.each(function(){
          $edit_notiChip += '<div class="chip mb-0">' +
            '<div class="chip-body">' +
              '<span class="chip-text" data-value="'+$(this).data('value')+'"><span class="bullet bullet-'+$(this).data('color')+' bullet-xs"></span> '+$(this).data('value')+'</span>' +
            '</div>' +
          '</div>';
        });

    $curr_chipVal.empty();

    $($curr_chipVal).append($edit_notiChip);


  });


  // --------------------------------------------
  //EVENT DELETION
  // --------------------------------------------
  $(document).on('click', '.noti-item-delete', function(e){
    var item = this;
    e.stopPropagation();
    $(item).closest('.noti-item').remove();
  })

  // Complete task strike through
  $(document).on('click', '.noti-item input', function(event){
    event.stopPropagation();
    $(this).closest('.noti-item').toggleClass("completed");
  });


  // --------------------------------------------
  // Filter
  // --------------------------------------------
  $("#noti-search").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    if(value!=""){
      $(".noti-item").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
      });
      var tbl_row = $(".noti-item:visible").length; //here tbl_test is table name

      //Check if table has row or not
      if ( tbl_row == 0 ){
        if(!$('.no-results').hasClass('show') ){
          $('.no-results').addClass('show');
        }
      }
      else{
        $('.no-results').removeClass('show');

      }
    }
    else{
      // If filter box is empty
      $(".noti-item").show();
      if($('.no-results').hasClass('show') ){
        $('.no-results').removeClass('show');
      }
    }
  });

});

$(window).on("resize", function() {
    // remove show classes from sidebar and overlay if size is > 992
    if ($(window).width() > 992) {
        if($('.app-content .app-content-overlay').hasClass('show')){
            $('.app-content .sidebar-left').removeClass('show');
            $('.app-content .app-content-overlay').removeClass('show');
        }
    }
});
