<?php
 
/*** PREVENT THE PAGE FROM BEING CACHED BY THE WEB BROWSER ***/
//header("Cache-Control: no-cache, must-revalidate");
//header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");

require_once("wp-authenticate.php");

/*** REQUIRE USER AUTHENTICATION ***/login();

/*** RETRIEVE LOGGED IN USER INFORMATION ***/$user = wp_get_current_user();

require_once("includes/header.php");

$currentPage = 'registrant-list';
include("includes/top_nav.php");
include("includes/side_nav.php");
?>  
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">Registrant List</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a href="#">Events</a>
                                    </li>
                                    <li class="breadcrumb-item active"> Event Organize 
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
                    <div class="form-group breadcrum-right">
                        <!--<div class="dropdown">
                            <button class="btn-icon btn btn-primary btn-round btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="feather icon-settings"></i></button>
                            <div class="dropdown-menu dropdown-menu-right"><a class="dropdown-item" href="#">Chat</a><a class="dropdown-item" href="#">Email</a><a class="dropdown-item" href="#">Calendar</a></div>
                        </div> -->
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Basic example section start -->
                <section id="basic-examples">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="ag-grid-btns d-flex justify-content-between flex-wrap mb-1">
                                            <div class="dropdown sort-dropdown mb-1 mb-sm-0">
                                                <button class="btn btn-white filter-btn dropdown-toggle border text-dark" type="button" id="dropdownMenuButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    1 - 20 of 500
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton6">
                                                    <a class="dropdown-item" href="#">20</a>
                                                    <a class="dropdown-item" href="#">50</a>
                                                    <a class="dropdown-item" href="#">100</a>
                                                    <a class="dropdown-item" href="#">150</a>
                                                </div>
                                            </div>
                                            <div class="ag-btns d-flex flex-wrap">
                                                <input type="text" class="ag-grid-filter form-control w-50 mr-1 mb-1 mb-sm-0" id="filter-text-box" placeholder="Search...." />
                                                <div class="btn-export">
                                                    <button class="btn-icon btn btn-primary ag-grid-export-btn">
                                                        <i class="feather icon-download"></i>
                                                        Export
                                                    </button>
                                                    <button class="btn-icon btn btn-success ag-grid-print-btn">
                                                        <i class="feather icon-printer"></i>
                                                        Print
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="myGrid" class="aggrid ag-theme-material"></div>  <!-- ag-theme-material -->
                            </div>
                        </div>
                    </div>
                </section>
                <!-- // Basic example section end -->

            </div>
        </div>
    </div>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

  
    <?php include("includes/footer.php");?>


    
    <script>
     $(document).ready(function() {
        
        var columnDefs = [
        {
          headerName: "Full Name",
          field: "full_name",
          editable: true,
          sortable: true,
          filter: true,
          width: 200,
          pinned: "left"
         // checkboxSelection: true,
         // headerCheckboxSelectionFilteredOnly: true,
          //headerCheckboxSelection: true
        },
        {
          headerName: "IC/Passport",
          field: "icnumber",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "DOB",
          field: "dob",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "Gender",
          field: "gender",
          editable: true,
          sortable: true,
          filter: true,
          width: 100
        },
        {
          headerName: "Email",
          field: "email",
          editable: true,
          sortable: true,
          filter: true,
          width: 250
        },
        {
          headerName: "Phone",
          field: "phone",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "Nationality",
          field: "nationality",
          editable: true,
          sortable: true,
          filter: true,
          width: 120
        },
        {
          headerName: "Chapter",
          field: "chapter",
          editable: true,
          sortable: true,
          filter: true,
          width: 200,
          pinned: "left"
        },
        {
          headerName: "NOM",
          field: "nom",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "Position",
          field: "position",
          editable: true,
          sortable: true,
          filter: true,
          width: 200
        },
        {
          headerName: "Specify",
          field: "position_specify",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "Senator No.",
          field: "senatorship",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "Name on Tag",
          field: "name_tag",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#F4ECF7'  
          }
        },
        {
          headerName: "Accommodation",
          field: "accommodation",
          editable: true,
          sortable: true,
          filter: true,
          width: 120,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#F4ECF7'  
          }
        },
        {
          headerName: "Shirt Size",
          field: "tshirt_size",
          editable: true,
          sortable: true,
          filter: true,
          width: 120,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#F4ECF7'  
          }
        },
        {
          headerName: "Meal",
          field: "meal",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#F4ECF7'  
          }
        },
        {
          headerName: "Pick Up",
          field: "pickup",
          editable: true,
          sortable: true,
          filter: true,
          width: 120,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#D6EAF8'  
          }
        },
        {
          headerName: "Arrival",
          field: "arrival_datetime",
          editable: true,
          sortable: true,
          filter: true,
          width: 200,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        {
          headerName: "Transport",
          field: "arrival_transport",
          editable: true,
          sortable: true,
          filter: true,
          width: 120,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        {
          headerName: "Detail",
          field: "arrival_detail",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        
        {
          headerName: "Station",
          field: "arrival_station",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
         {
          headerName: "Drop Off",
          field: "dropoff",
          editable: true,
          sortable: true,
          filter: true,
          width: 120,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#D6EAF8'  
          }
        },
        {
          headerName: "Departure",
          field: "departure_datetime",
          editable: true,
          sortable: true,
          filter: true,
          width: 200,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        {
          headerName: "Transport",
          field: "departure_transport",
          editable: true,
          sortable: true,
          filter: true,
          width: 120,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        {
          headerName: "Detail",
          field: "departure_detail",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        {
          headerName: "Station",
          field: "departure_station",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EBF5FB'  
          }
        },
        {
          headerName: "Remarks",
          field: "remarks",
          editable: true,
          sortable: true,
          filter: true,
          width: 300,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#EAECEE'  
          }
        },
        {
          headerName: "Emergency Name",
          field: "emergency_name",
          editable: true,
          sortable: true,
          filter: true,
          width: 200,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#FEF9E7' // light green 
          }
        },
        {
          headerName: "Contact",
          field: "emergency_phone",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#FEF9E7' // light green 
          }
        },
        {
          headerName: "Relationship",
          field: "relationship",
          editable: true,
          sortable: true,
          filter: true,
          width: 150,
          cellStyle: {
            // you can use either came case or dashes, the grid converts to whats needed
            backgroundColor: '#FEF9E7' // light green 
          }
        }
       
      ];
           
      /*** COLUMN DEFINE ***/
    /**  var columnDefs = [
        {
          headerName: "First Name",
          field: "firstname",
          editable: true,
          sortable: true,
          filter: true,
          width: 175,
          checkboxSelection: true,
          headerCheckboxSelectionFilteredOnly: true,
          headerCheckboxSelection: true
        },
        {
          headerName: "Last Name",
          field: "lastname",
          editable: true,
          sortable: true,
          filter: true,
          width: 175
        },
        {
          headerName: "Company",
          field: "company",
          editable: true,
          sortable: true,
          filter: true,
          width: 250
        },
        {
          headerName: "City",
          field: "city",
          editable: true,
          sortable: true,
          filter: true,
          width: 125
        },
        {
          headerName: "Country",
          field: "country",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        },
        {
          headerName: "State",
          field: "state",
          editable: true,
          sortable: true,
          filter: true,
          width: 125
        },
        {
          headerName: "Zip",
          field: "zip",
          editable: true,
          sortable: true,
          filter: true,
          width: 125
        },
        {
          headerName: "Email",
          field: "email",
          editable: true,
          sortable: true,
          filter: true,
          width: 260,
          pinned: "left"
        },
        {
          headerName: "Followers",
          field: "followers",
          editable: true,
          sortable: true,
          filter: true,
          width: 150
        }
      ]; **/
    
      /*** GRID OPTIONS ***/
      var gridOptions = {
        columnDefs: columnDefs,
        rowSelection: "multiple",
        floatingFilter: true,
        filter: true,
        pagination: true,
        paginationPageSize: 20,
        pivotPanelShow: "always",
        colResizeDefault: "shift",
        animateRows: true,
        resizable: true
      };
    
      /*** DEFINED TABLE VARIABLE ***/
      var gridTable = document.getElementById("myGrid");
    
      /*** GET TABLE DATA FROM URL ***/
    
      agGrid                                
        .simpleHttpRequest({ url: "https://jcimalaysia.cc/membership/functions/registrant_list.php?userlogin=<?php echo $user->user_login;?>" })
        .then(function(data) {
          gridOptions.api.setRowData(data);
        });
    
      /*** FILTER TABLE ***/
      function updateSearchQuery(val) {
        gridOptions.api.setQuickFilter(val);
      }
    
      $(".ag-grid-filter").on("keyup", function() {
        updateSearchQuery($(this).val());
      });
    
      /*** CHANGE DATA PER PAGE ***/
      function changePageSize(value) {
        gridOptions.api.paginationSetPageSize(Number(value));
      }
    
      $(".sort-dropdown .dropdown-item").on("click", function() {
        var $this = $(this);
        changePageSize($this.text());
        $(".filter-btn").text("1 - " + $this.text() + " of 500");
      });
    
      /*** EXPORT AS CSV BTN ***/
      $(".ag-grid-export-btn").on("click", function(params) {
        gridOptions.api.exportDataAsCsv();
      });
    
      $(".ag-grid-print-btn").on("click", function(params) {
          var gridApi = gridOptions.api;
            
                setPrinterFriendly(gridApi);
            
                setTimeout( function( ) {
                    print();
                    setNormal(gridApi);
                }, 2000);
      });
      
      
        
        function setPrinterFriendly(api) {
            var eGridDiv = document.querySelector('#myGrid');
            eGridDiv.style.width = '';
            eGridDiv.style.height = '';
        
            api.setDomLayout('print');
        }
        
        function setNormal(api) {
            var eGridDiv = document.querySelector('#myGrid');
            //eGridDiv.style.width = '600px';
            //eGridDiv.style.height = '200px';
        
            api.setDomLayout('normal');
        }
        
        // setup the grid after the page has finished loading
        document.addEventListener('DOMContentLoaded', function() {
            var gridDiv = document.querySelector('#myGrid');
            new agGrid.Grid(gridDiv, gridOptions);
        });
        
      /*** INIT TABLE ***/
      new agGrid.Grid(gridTable, gridOptions);
    
      /*** SET OR REMOVE EMAIL AS PINNED DEPENDING ON DEVICE SIZE ***/
    
      if ($(window).width() < 768) {
        gridOptions.columnApi.setColumnPinned("chapter", null);
        
      } else {
        gridOptions.columnApi.setColumnPinned("chapter", "left");
       
      }
      $(window).on("resize", function() {
        if ($(window).width() < 768) {
          gridOptions.columnApi.setColumnPinned("chapter", null);
         
          
        } else {
          gridOptions.columnApi.setColumnPinned("chapter", "left");
         
        }
      });
    });
        
    </script>    
</body>
<!-- END: Body-->

</html>