<?php


require './vendor/autoload.php';



/****************helper functions ********************/


function clean($string) {


return htmlentities($string);


}



function redirect($location){


return header("Location: {$location}");

}


function set_message($message) {


	if(!empty($message)){


		$_SESSION['message'] = $message;

	}else {

		$message = "";

	}


}



function display_message(){


	if(isset($_SESSION['message'])) {


		echo $_SESSION['message'];

		unset($_SESSION['message']);

	}



}



function token_generator(){


$token = $_SESSION['token'] =  md5(uniqid(mt_rand(), true));

return $token;


}


function validation_errors($error_message) {

$error_message = <<<DELIMITER

<div class="alert alert-danger alert-dismissible text-center" role="alert">
  	<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
  	<strong>Warning!</strong> $error_message
 </div>
DELIMITER;

return $error_message;
		




}



function email_exists($email) {

	$sql = "SELECT id FROM jcim_users WHERE user_email = '$email'";

	$result = query($sql);

	if(row_count($result) == 1 ) {

		return true;

	} else {


		return false;

	}



}



function icnumber_exists($icnumber) {

	$sql = "SELECT id FROM jcim_users WHERE user_login = '$icnumber'";

	$result = query($sql);

	if(row_count($result) == 1 ) {

		return true;

	} else {


		return false;

	}



}


function send_email($email=null, $subject=null, $msg=null, $headers=null){


	$mail = new PHPMailer();

	$mail->isSMTP();
	$mail->Host = Config::SMTP_HOST;
	$mail->Username = Config::SMTP_USER;
	$mail->Password = Config::SMTP_PASSWORD;;
	$mail->Port = Config::SMTP_PORT;;
	$mail->SMTPAuth = true;
	$mail->SMTPSecure = 'tls';
	$mail->isHTML(true);
	$mail->CharSet = 'UTF-8';

	$mail->setFrom('webmaster@jcimalaysia.cc', 'JCIM Webmaster');
	$mail->addAddress($email);


	$mail->Subject = $subject;
	$mail->Body    = $msg;
	$mail->AltBody = $msg;

	if(!$mail->send()) {

		//echo 'Message could not be sent.';
		//echo 'Mailer Error: ' . $mail->ErrorInfo;

        set_message("<div class='alert alert-warning alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Warning! </strong>Message could not be sent.<br>Mailer Error: ". $mail->ErrorInfo ."</div>");
                
	} else {
	    
	    set_message("<div class='alert alert-success alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Success! </strong>Message has been sent</div>");
		//echo 'Message has been sent';
	}



//	return mail($email, $subject, $msg, $headers);


}



/****************Validation functions ********************/



function validate_user_registration(){

	$errors = [];

	$min = 2;
	$max = 30;



	if($_SERVER['REQUEST_METHOD'] == "POST") {


		$first_name 		= clean($_POST['first_name']);
		$last_name 			= clean($_POST['last_name']);
		$display_name 		= clean($_POST['display_name']);
		$icnumber 		    = clean($_POST['icnumber']);
		$email 				= clean($_POST['email']);
		$password			= clean($_POST['password']);
		$confirm_password	= clean($_POST['confirm_password']);



		if(strlen($first_name) < $min) {

			$errors[] = "Your first name cannot be less than {$min} characters";

		}

		if(strlen($first_name) > $max) {

			$errors[] = "Your first name cannot be more than {$max} characters";

		}




		if(strlen($last_name) < $min) {

			$errors[] = "Your Last name cannot be less than {$min} characters";

		}


		if(strlen($last_name) > $max) {

			$errors[] = "Your Last name cannot be more than {$max} characters";

		}

		if(strlen($icnumber) < $min) {

			$errors[] = "Your Username cannot be less than {$min} characters";

		}

		if(strlen($icnumber) > $max) {

			$errors[] = "Your Username cannot be more than {$max} characters";

		}

		

		if(icnumber_exists($icnumber)){

			$errors[] = "Sorry that username is already is taken";

		}



		if(email_exists($email)){

			$errors[] = "Sorry that email already is registered";

		}




		if(strlen($email) < $min) {

			$errors[] = "Your email cannot be more than {$max} characters";

		}

		if($password !== $confirm_password) {

			$errors[] = "Your password fields do not match";

		}



		if(!empty($errors)) {

			foreach ($errors as $error) {

			echo validation_errors($error);

			
			}


		} else {


			if(register_user($first_name, $last_name, $display_name, $icnumber, $email, $password)) {

                
				//set_message("<p class='bg-success text-center'>Please check your email or spam folder for activation link</p>");

				//redirect("auth-login.php");
				
				/*************** Please check your email for activation link ************/
				set_message("<div class='alert alert-success alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Success! </strong>Please check your email or spam folder for activation link</div>");

                header('Refresh:3; url=auth-login.php');

			} else {

			
				//set_message("<p class='bg-danger text-center'>Sorry we could not register the user</p>");

				//redirect("auth-register.php");
				
					/********** could not register the user ************/
				set_message("<div class='alert alert-warning alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Warning! </strong>Sorry we could not register the user</div>");
                
                header('Refresh:3; url=auth-register.php');

			}



		}



	} // post request 



} // function 

/****************Register user functions ********************/

function register_user($first_name, $last_name, $display_name, $icnumber, $email, $password) {


	$first_name     = escape($first_name);
	$last_name      = escape($last_name);
	$display_name   = escape($display_name);
	$username       = escape($icnumber);
	$email          = $email;
	$password       = escape($password);



	if(email_exists($email)) {


		return false;


	} else if (icnumber_exists($icnumber)) {

		return false;

	} else {

		$password   = password_hash($password, PASSWORD_BCRYPT, array('cost'=>12));

		$validation_code = md5($icnumber . microtime());


		//$sql = "INSERT INTO users(first_name, last_name, ic_number, email, password, validation_code, active)";
		//$sql.= " VALUES('$first_name','$last_name','$icnumber','$email','$password','$validation_code', 0)";

		//query('SET NAMES utf8');

		//$result = query($sql);
		//confirm($result);

        //wordpress user
        $sql = "INSERT INTO `jcim_users` (`user_login`, `user_pass`, `user_nicename`, `user_email`, `user_registered`, `user_activation_key`, `user_status`, `display_name`)";
        $sql.= " VALUES ('$icnumber', '$password', '$display_name', '$email', CURRENT_TIMESTAMP, '$validation_code', '0', '$display_name')";
        
        query('SET NAMES utf8');

		$result = query($sql);
		confirm($result);

        //User Roles
        $capabilities = 'a:1:{s:4:"free";b:1;}';
        
        $sql = "INSERT INTO `jcim_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`)";
        $sql.= " VALUES (NULL, (Select max(id) FROM jcim_users), 'jcim_capabilities', '$capabilities')";
        
        query('SET NAMES utf8');

		$result = query($sql);
		confirm($result);

        // User Level            
        $sql = "INSERT INTO `jcim_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`)";
        $sql.= "VALUES (NULL, (Select max(id) FROM jcim_users), 'jcim_user_level', '0')";

        query('SET NAMES utf8');

		$result = query($sql);
		confirm($result);

        // Nickname            
        $sql = "INSERT INTO `jcim_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`)";
        $sql.= "VALUES (NULL, (Select max(id) FROM jcim_users), 'nickname', $username)";

        query('SET NAMES utf8');

		$result = query($sql);
		confirm($result);
		
		// First Name            
        $sql = "INSERT INTO `jcim_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`)";
        $sql.= "VALUES (NULL, (Select max(id) FROM jcim_users), 'first_name', '$first_name')";

        query('SET NAMES utf8');

		$result = query($sql);
		confirm($result);

        // First Name            
        $sql = "INSERT INTO `jcim_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`)";
        $sql.= "VALUES (NULL, (Select max(id) FROM jcim_users), 'last_name', '$last_name')";

        query('SET NAMES utf8');

		$result = query($sql);
		confirm($result);


		$subject = "Activate Account";
		$msg = "Hi $display_name, <br>
		Welcome onboard !<br>
		Please click the link below to activate your Account
		<a href=\" " . Config::PRODUCTION_URL ."/membership/auth-activate.php?email=$email&code=$validation_code\">
		LINK HERE</a>";

		$headers = "From: noreply@jcimalaysia.cc";



		send_email($email, $subject, $msg, $headers);


		return true;

	}



} 


/****************Activate user functions ********************/


function activate_user() {


	if($_SERVER['REQUEST_METHOD'] == "GET") {


		if(isset($_GET['email'])) {


			$email = clean($_GET['email']);

			$validation_code = clean($_GET['code']);


			$sql = "SELECT ID FROM jcim_users WHERE user_email = '".$_GET['email']."' AND user_activation_key = '".escape($_GET['code'])."' ";
			$result = query($sql);
			confirm($result);

			if(row_count($result) == 1) {

			$sql2 = "UPDATE jcim_users SET user_status = 1, user_activation_key = 0 WHERE user_email = '".$email."' AND user_activation_key = '".escape($validation_code)."' ";
			$result2 = query($sql2);
			confirm($result2);

		
			//set_message("<p class='bg-success'>Your account has been activated please login</p>");

				/******* account has been activated ********/
			set_message("<div class='alert alert-success alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Success! </strong>Your account has been activated, please login</div>");

            header('Refresh:3; url=auth-login.php');
			//redirect("auth-login.php");
			

		} else {

			
			//set_message("<p class='bg-danger'>Sorry Your account could not be activated </p>");

			//redirect("auth-login.php");
			
			/********   account could not be activated  *******/
			set_message("<div class='alert alert-warning alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Warning! </strong>Sorry Your account could not be activated </div>");


             header('Refresh:3; url=auth-login.php');

			}




		} 


	}



} // function 

/****************Validate user login functions ********************/



function validate_user_login(){

	$errors = [];

	$min = 3;
	$max = 20;



	if($_SERVER['REQUEST_METHOD'] == "POST") {


		$icnumber 		= clean($_POST['icnumber']);
		$password	= clean($_POST['password']);
		$remember   = isset($_POST['remember']);




		if(empty($icnumber)) {

			$errors[] = "Email field cannot be empty";

		}


		if(empty($password)) {

			$errors[] = "Password field cannot be empty";

		}



		if(!empty($errors)) {

				foreach ($errors as $error) {

				echo validation_errors($error);

				
				}


			} else {


				if(login_user($icnumber, $password, $remember)) {


					redirect("index.php");


				} else {


				echo validation_errors("Your credentials are not correct");		



				}



			}



	}


} // function 


/****************User login functions ********************/


	function login_user($icnumber, $password, $remember) {


		$sql = "SELECT user_pass, ID FROM jcim_users WHERE user_login = '".escape($icnumber)."' AND user_status = 1";

		$result = query($sql);

		if(row_count($result) == 1) {

			$row = fetch_array($result);

			$db_password = $row['user_pass'];


			if(password_verify($password, $db_password)){

				if($remember == "on") {

					setcookie('icnumber', $icnumber, time() + 86400);

				}

				$_SESSION['icnumber'] = $icnumber;

				return true;

			}else {


				return false;
			}

			return true;

		} else {


			return false;



		}



	} // end of function
	
	
/****************First Time login functions ********************/
	
	function first_login($icnumber) {


		$query = "SELECT icnumber FROM jcim1_first_login WHERE user_login = '".escape($icnumber)."'";

		$results = query($query);

		if(row_count($results) == 1) {

		    return false;

	    } else {
        
        $sql = "INSERT INTO `jcim1_first_login` (`icnumber`, `last_session`)";
        $sql.= " VALUES ('$icnumber', CURRENT_TIMESTAMP)";
	}
}



/****************logged in function ********************/



function logged_in(){

	if(isset($_SESSION['icnumber']) || isset($_COOKIE['icnumber'])){


		return true;

	} else {


		return false;
	}

}	// functions


/****************Recover Password function ********************/



function recover_password() {


	if($_SERVER['REQUEST_METHOD'] == "POST") {

		if(isset($_SESSION['token']) && $_POST['token'] === $_SESSION['token']) {

			$email = clean($_POST['email']);


			if(email_exists($email)) {


			$validation_code = md5($email . microtime());


			setcookie('temp_access_code', $validation_code, time()+ 86400, "/");


			$sql = "UPDATE jcim_users SET user_activation_key = '".escape($validation_code)."' WHERE user_email = '".escape($email)."'";
			$result = query($sql);



			$subject = "Please reset your password";
			$message = "<h2>Hi,<br>  
			Here is your password reset code, click the link below or paste in the browser</h2> <h1>{$validation_code}</h1>
			<a href=\" " . Config::PRODUCTION_URL ."/membership/auth-reset-password.php?email=$email&code=$validation_code\">
			". Config::PRODUCTION_URL ."/membership/auth-reset-password.php?email=$email&code=$validation_code</a>";
			
			$headers = "From: noreply@jcimalaysia.cc";


			send_email($email, $subject, $message, $headers);

			//set_message("<p class='bg-success text-center'>Please check your email or spam folder for a password reset code</p>");
			set_message("<div class='alert alert-success alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Success! </strong>Please check your email or spam folder for a password reset link</div>");

            header('Refresh:3; url=auth-login.php');
            //redirect("auth-login.php");
			

			} else {


				echo validation_errors("This emails does not exist");


			}



		} else {


			redirect("auth-login.php");

		}

		// token checks

 
		if(isset($_POST['back_login'])) {

			redirect("auth-login.php");


		}

	} // post request


} // functions

/**************** Code  Validation ********************/


function validate_code () {


	if(isset($_COOKIE['temp_access_code'])) {

			if(!isset($_GET['email']) && !isset($_GET['code'])) {

				redirect("index.php");


			} else if (empty($_GET['email']) || empty($_GET['code'])) {

				redirect("index.php");


			} else {



				if(isset($_POST['code'])) {

					$email = clean($_GET['email']);

					$validation_code = clean($_POST['code']);

					$sql = "SELECT ID FROM jcim_users WHERE user_activation_key = '".escape($validation_code)."' AND user_email = '".escape($email)."'";
					$result = query($sql);

					if(row_count($result) == 1) {

						setcookie('temp_access_code', $validation_code, time()+ 900);

						redirect("auth-reset-password.php?email=$email&code=$validation_code");

					} else {

						echo validation_errors("Sorry wrong validation code");

					}
				}
			}


	} else {
	
		//set_message("<p class='bg-danger text-center'>Sorry your validation cookie was expired</p>");

		redirect("auth-recover-password.php");
		
			/***** Validate Cookie Expire****/
		set_message("<div class='alert alert-danger alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Warning! </strong>Sorry your validation cookie was expired</div>");


	}

}

/**************** Password Reset Function ********************/


function password_reset() {

	if(isset($_COOKIE['temp_access_code'])) {


		if(isset($_GET['email']) && isset($_GET['code'])) {



			if(isset($_SESSION['token']) && isset($_POST['token'])) {


				if($_POST['token'] === $_SESSION['token']) {


					if($_POST['password'] === $_POST['confirm_password'])  { 

						$updated_password = password_hash($_POST['password'], PASSWORD_BCRYPT, array('cost'=>12));
						//$updated_password = md5($_POST['password']);

						$sql = "UPDATE jcim_users SET user_pass = '".escape($updated_password)."', user_activation_key = 0, user_status = 1 WHERE user_email = '".escape($_GET['email'])."'";
						query($sql);

						
						//set_message("<p class='bg-success text-center'>You passwords has been updated, please login</p>");

						//redirect("auth-login.php");
						
						/***** You passwords has been updated, please login *****/
						set_message("<div class='alert alert-success alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Success! </strong>You passwords has been updated, We redirect you to login page now.</div>");
                        
                        header('Refresh:3; url=auth-login.php');
                        //redirect("auth-login.php");
						

						} else {

							echo validation_errors("Password fields don't match");

						}
				  }

			} 
		} 


	}else {

		
		//set_message("<p class='bg-danger text-center'>Sorry your time has expired</p>");

		redirect("auth-recover-password.php");
		
		/**** your time has expired *******/
		set_message("<div class='alert alert-danger alert-dismissible text-center' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='Close'><span aria-hidden='true'>&times;</span></button><strong>Warning! </strong>Sorry your time has expired</div>");


	}
}










